function Y = prox_rank(X,thres,L)

[n1,n2,n3] = size(X);
k          = min(n1,n2);
L_inv      = inv(L);
X_L        = ttm(X,L,3);
X_L        = double(X_L);
Y          = zeros(n1,n2,n3);
    
for i = 1 : n3
    [U,S,V] = svd(X_L(:,:,i),'econ');
    S       = diag(S);
    for j = 1 : k
        if S(j) <= sqrt(thres)
            S(j) = 0;
        end
    end
    r        = length(S);
    Y(:,:,i) = U(:,1:r)*diag(S)*V(:,1:r)';
end
Y = ttm(Y,L_inv,3);
Y = double(Y);
end